/*:
 * @target MZ
 * @plugindesc メッセージの名前が「あなた」または「you」の場合、メッセージウィンドウと名前ボックスの枠の色を黒くします。
 * @help このプラグインは、メッセージウィンドウおよび名前ボックスの名前が「あなた」または「you」の場合、枠の色を黒くします。
 *
 * プラグインの動作には、黒いウィンドウスキン (img/system/BlackWindow.png) を用意する必要があります。
 */

(() => {
    const _Window_NameBox_refresh = Window_NameBox.prototype.refresh;
    Window_NameBox.prototype.refresh = function() {
        const name = this._name;
        const messageWindow = this._messageWindow;
        if (name === "あなた" || name === "you") {
            messageWindow.setFrameColor('black');
            this.setFrameColor('black');
        } else {
            messageWindow.setFrameColor('default');
            this.setFrameColor('default');
        }
        _Window_NameBox_refresh.call(this);
    };

    Window_Message.prototype.setFrameColor = function(color) {
        if (color === 'black') {
            this.windowskin = ImageManager.loadSystem('BlackWindow');
        } else {
            this.windowskin = ImageManager.loadSystem('Window');
        }
    };

    Window_NameBox.prototype.setFrameColor = function(color) {
        if (color === 'black') {
            this.windowskin = ImageManager.loadSystem('BlackWindow');
        } else {
            this.windowskin = ImageManager.loadSystem('Window');
        }
    };
})();